/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.BaseSimpleFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

public class FileSystemsTest {
    @Before
    @After
    public void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)new File(".niogit"));
    }

    @Test
    public void testGetDefault() {
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getDefault()).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test
    public void testGetFileSystemByURI() {
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("default:///"))).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystems.getFileSystem((URI)URI.create("file:///"))).isNotNull()).isInstanceOf(BaseSimpleFileSystem.class);
    }

    @Test
    public void testNewFileSystem() {
        HashMap<String, String> env = new HashMap<String, String>(2);
        env.put("userName", "user");
        env.put("password", "pass");
        FileSystem fs = FileSystems.newFileSystem((URI)URI.create("git://my-test"), env);
        Assertions.assertThat((Object)fs).isNotNull();
        FileSystem newFS = FileSystems.newFileSystem((Path)JGitPathImpl.create((JGitFileSystem)((JGitFileSystem)fs), (String)"new_test", (String)"my-other-test", (boolean)false), null);
        Assertions.assertThat((Object)newFS).isNotNull();
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testNewOnExistingFileSystem() {
        HashMap<String, String> env = new HashMap<String, String>(2);
        env.put("userName", "user");
        env.put("password", "pass");
        FileSystems.newFileSystem((URI)URI.create("git://test"), env);
        FileSystems.newFileSystem((URI)URI.create("git://test"), env);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFileSystemNull() {
        FileSystems.getFileSystem(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull1() {
        Map emptyMap = Collections.emptyMap();
        FileSystems.newFileSystem(null, emptyMap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull2() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull3() {
        FileSystems.newFileSystem((URI)null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull4() {
        FileSystems.newFileSystem((Path)null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull5() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull6() {
        FileSystems.newFileSystem((URI)URI.create("jgit:///test"), null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemNull7() {
        FileSystems.newFileSystem(null, null, null);
    }
}

