/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.AbstractBaseTest;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class SimpleFileVisitorTest
extends AbstractBaseTest {
    final AtomicInteger preDir = new AtomicInteger();
    final AtomicInteger postDir = new AtomicInteger();
    final AtomicInteger fileC = new AtomicInteger();
    final AtomicInteger failFile = new AtomicInteger();
    final SimpleFileVisitor<Path> simple = new SimpleFileVisitor<Path>(){

        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            SimpleFileVisitorTest.this.preDir.addAndGet(1);
            return super.preVisitDirectory((Object)dir, attrs);
        }

        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            SimpleFileVisitorTest.this.fileC.addAndGet(1);
            return super.visitFile((Object)file, attrs);
        }

        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            SimpleFileVisitorTest.this.failFile.addAndGet(1);
            return super.visitFileFailed((Object)file, exc);
        }

        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            SimpleFileVisitorTest.this.postDir.addAndGet(1);
            return super.postVisitDirectory((Object)dir, exc);
        }
    };

    @Test
    public void testWalker() {
        Path dir = this.newTempDir(null);
        Path file1 = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        Files.walkFileTree((Path)dir, this.simple);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(1);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
        this.cleanupVisitor();
        Files.walkFileTree((Path)file1, this.simple);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(0);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(1);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep2() {
        Path dir = this.newTempDir(null);
        Path subDir = this.newTempDir(dir);
        Path subSubDir = this.newTempDir(subDir);
        this.newTempDir(subSubDir);
        this.cleanupVisitor();
        Files.walkFileTree((Path)dir, this.simple);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(4);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(4);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(0);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testWalkerDeep1() {
        Path dir = this.newTempDir(null);
        Path subDir = this.newTempDir(dir);
        Path subSubDir = this.newTempDir(subDir);
        Path subSubSubDir = this.newTempDir(subSubDir);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.cleanupVisitor();
        Files.walkFileTree((Path)dir, this.simple);
        Assertions.assertThat((int)this.preDir.get()).isEqualTo(4);
        Assertions.assertThat((int)this.postDir.get()).isEqualTo(4);
        Assertions.assertThat((int)this.fileC.get()).isEqualTo(2);
        Assertions.assertThat((int)this.failFile.get()).isEqualTo(0);
    }

    @Test
    public void testException() {
        Path dir = this.newTempDir(null);
        Path file = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        IOException myException = new IOException();
        try {
            this.simple.visitFileFailed((Object)file, myException);
            Assertions.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assertions.assertThat((Throwable)ex).isEqualTo((Object)myException);
        }
        try {
            this.simple.postVisitDirectory((Object)file, myException);
            Assertions.fail((String)"should throw an exception");
        }
        catch (Exception ex) {
            Assertions.assertThat((Throwable)ex).isEqualTo((Object)myException);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void preVisitDirectoryNull1() {
        Path dir = this.newTempDir(null);
        Path file = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.simple.preVisitDirectory(null, Files.readAttributes((Path)file, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void preVisitDirectoryNull2() {
        Path dir = this.newTempDir(null);
        this.simple.preVisitDirectory((Object)dir, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void preVisitDirectoryNull3() {
        this.simple.preVisitDirectory(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileNull1() {
        Path dir = this.newTempDir(null);
        Path file = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.simple.visitFile(null, Files.readAttributes((Path)file, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileNull2() {
        Path dir = this.newTempDir(null);
        this.simple.visitFile((Object)dir, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileNull3() {
        this.simple.visitFile(null, null);
    }

    @Test
    public void postVisitDirectoryNull1() {
        Path dir = this.newTempDir(null);
        Path file = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.simple.postVisitDirectory((Object)dir, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void postVisitDirectoryNull2() {
        this.simple.postVisitDirectory(null, new IOException());
    }

    @Test(expected=IllegalArgumentException.class)
    public void postVisitDirectoryNull3() {
        this.simple.postVisitDirectory(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileFailedNull1() {
        Path dir = this.newTempDir(null);
        Path file = Files.createTempFile((Path)dir, (String)"foo", (String)"bar", (FileAttribute[])new FileAttribute[0]);
        this.simple.visitFileFailed((Object)file, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileFailedNull2() {
        this.simple.visitFileFailed(null, new IOException());
    }

    @Test(expected=IllegalArgumentException.class)
    public void visitFileFailedNull3() {
        this.simple.visitFileFailed(null, null);
    }

    protected void cleanupVisitor() {
        this.preDir.set(0);
        this.postDir.set(0);
        this.fileC.set(0);
        this.failFile.set(0);
    }
}

