/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.net.URI;
import java.util.List;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ListAssert;
import org.fest.assertions.api.ObjectAssert;
import org.junit.Test;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public class FileSystemProvidersTest {
    @Test
    public void generalTests() {
        ((ListAssert)((ListAssert)Assertions.assertThat((List)FileSystemProviders.installedProviders()).isNotNull()).isNotEmpty()).hasSize(2);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystemProviders.getDefaultProvider()).isNotNull()).isInstanceOf(SimpleFileSystemProvider.class);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("default:///"))).isNotNull()).isInstanceOf(SimpleFileSystemProvider.class);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("file:///"))).isNotNull()).isInstanceOf(SimpleFileSystemProvider.class);
        ((ObjectAssert)Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("git:///"))).isNotNull()).isInstanceOf(JGitFileSystemProvider.class);
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void resolveNonExistentProvider() {
        ((ObjectAssert)Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("nothing:///"))).isNotNull()).isInstanceOf(JGitFileSystemProvider.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveProviderNull() {
        FileSystemProviders.resolveProvider(null);
    }
}

