/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.backend.server.AbstractDeleteModuleObserverBridge;
import org.guvnor.common.services.project.events.DeleteModuleEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.project.ModuleFactory;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceDeleted;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceUpdated;

public class AbstractDeleteModuleObserverBridgeTest {
    private AbstractDeleteModuleObserverBridge bridge;
    private IOService ioService;
    private ModuleFactory<Module> moduleFactory;
    private Event<DeleteModuleEvent> deleteModuleEvent;
    private SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);

    @Before
    public void setup() {
        this.ioService = (IOService)Mockito.mock(IOService.class);
        this.moduleFactory = (ModuleFactory)Mockito.mock(ModuleFactory.class);
        this.deleteModuleEvent = (Event)Mockito.mock(Event.class);
        this.bridge = new AbstractDeleteModuleObserverBridge<Module>(this.ioService, this.deleteModuleEvent){

            protected Module getModule(Path path) {
                return AbstractDeleteModuleObserverBridgeTest.this.moduleFactory.simpleModuleInstance(path);
            }
        };
    }

    @Test
    public void testResourceDeletedEventPomFile() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        this.bridge.onBatchResourceChanges(new ResourceDeletedEvent(path, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }

    @Test
    public void testResourceDeletedEventNonPomFile() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        this.bridge.onBatchResourceChanges(new ResourceDeletedEvent(path, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)0))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }

    @Test
    public void testResourceBatchChangesEventUpdatePomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceUpdated(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)0))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }

    @Test
    public void testResourceBatchChangesEventUpdateNonPomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceUpdated(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)0))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }

    @Test
    public void testResourceBatchChangesEventDeletePomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"pom.xml");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/pom.xml");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceDeleted(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }

    @Test
    public void testResourceBatchChangesEventDeleteNonPomFile() {
        final org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Path nioPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"cheese.drl");
        Mockito.when((Object)path.toURI()).thenReturn((Object)"file://module1/cheese.drl");
        Mockito.when((Object)this.ioService.get((URI)Mockito.any(URI.class))).thenReturn((Object)nioPath);
        HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> batch = new HashMap<org.uberfire.backend.vfs.Path, Collection<ResourceChange>>(){
            {
                this.put(path, new ArrayList<ResourceChange>(){
                    {
                        this.add(new ResourceDeleted(""));
                    }
                });
            }
        };
        this.bridge.onBatchResourceChanges(new ResourceBatchChangesEvent((Map)batch, "message", this.sessionInfo));
        ((Event)Mockito.verify(this.deleteModuleEvent, (VerificationMode)Mockito.times((int)0))).fire((Object)((DeleteModuleEvent)Mockito.any(DeleteModuleEvent.class)));
    }
}

