/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Arrays;
import java.util.Collections;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.DefaultAuthorizationEntry;
import org.uberfire.security.impl.authz.DefaultAuthorizationPolicy;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DotNamedPermission;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPermissionManagerTest {
    private static final String PERMISSION_NAME = "guideddecisiontable.edit.columns";
    private DefaultAuthorizationPolicy authorizationPolicy;
    private DefaultPermissionManager defaultPermissionManager;

    @Before
    public void setUp() {
        this.defaultPermissionManager = (DefaultPermissionManager)Mockito.spy((Object)new DefaultPermissionManager());
        this.authorizationPolicy = (DefaultAuthorizationPolicy)Mockito.spy((Object)new DefaultAuthorizationPolicy());
        this.defaultPermissionManager.setAuthorizationPolicy((AuthorizationPolicy)this.authorizationPolicy);
    }

    @Test
    public void testResolvePermissionsCustomDeniedOverDefaultGranted() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        RoleImpl businessUserRole = new RoleImpl("business-user");
        GroupImpl directorGroup = new GroupImpl("director");
        UserImpl user = this.makeUser("director", (Group)directorGroup, new Role[]{businessUserRole});
        this.mockDefaultPermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection());
        this.mockRolePermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Role)businessUserRole, 0);
        this.mockDefaultGroupPermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection(), (Group)directorGroup);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_DENIED, (Object)permission.getResult());
    }

    @Test
    public void testResolvePermissionsCustomGrantedOverDefaultDenied() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        RoleImpl businessUserRole = new RoleImpl("business-user");
        GroupImpl directorGroup = new GroupImpl("director");
        UserImpl user = this.makeUser("director", (Group)directorGroup, new Role[]{businessUserRole});
        this.mockDefaultPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection());
        this.mockRolePermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection(), (Role)businessUserRole, 0);
        this.mockDefaultGroupPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Group)directorGroup);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_GRANTED, (Object)permission.getResult());
    }

    @Test
    public void testResolvePermissionsTwoCustomRolesGranted() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        RoleImpl businessUserRole = new RoleImpl("business-user");
        RoleImpl managerRole = new RoleImpl("manager");
        GroupImpl directorGroup = new GroupImpl("director");
        UserImpl user = this.makeUser("director", (Group)directorGroup, new Role[]{businessUserRole, managerRole});
        this.mockDefaultPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection());
        this.mockRolePermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Role)businessUserRole, 0);
        this.mockRolePermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection(), (Role)managerRole, 1);
        this.mockDefaultGroupPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Group)directorGroup);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_GRANTED, (Object)permission.getResult());
    }

    @Test
    public void testResolvePermissionsTwoCustomRolesDenied() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        RoleImpl businessUserRole = new RoleImpl("business-user");
        RoleImpl managerRole = new RoleImpl("manager");
        GroupImpl directorGroup = new GroupImpl("director");
        UserImpl user = this.makeUser("director", (Group)directorGroup, new Role[]{businessUserRole, managerRole});
        this.mockDefaultPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection());
        this.mockRolePermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Role)businessUserRole, 1);
        this.mockRolePermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection(), (Role)managerRole, 0);
        this.mockDefaultGroupPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Group)directorGroup);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_DENIED, (Object)permission.getResult());
    }

    @Test
    public void testResolvePermissionsTwoCustomRolesSamePriority() {
        VotingStrategy priority = VotingStrategy.PRIORITY;
        RoleImpl businessUserRole = new RoleImpl("business-user");
        RoleImpl managerRole = new RoleImpl("manager");
        GroupImpl directorGroup = new GroupImpl("director");
        UserImpl user = this.makeUser("director", (Group)directorGroup, new Role[]{businessUserRole, managerRole});
        this.mockDefaultPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection());
        this.mockRolePermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Role)businessUserRole, 0);
        this.mockRolePermissions(this.authorizationPolicy, this.makeGrantedPermissionCollection(), (Role)managerRole, 0);
        this.mockDefaultGroupPermissions(this.authorizationPolicy, this.makeDeniedPermissionCollection(), (Group)directorGroup);
        PermissionCollection resolvedPermission = this.defaultPermissionManager.resolvePermissions((User)user, priority);
        Permission permission = resolvedPermission.get(PERMISSION_NAME);
        Assert.assertEquals((Object)AuthorizationResult.ACCESS_GRANTED, (Object)permission.getResult());
    }

    private void mockDefaultGroupPermissions(DefaultAuthorizationPolicy authorizationPolicy, DefaultPermissionCollection permissionCollection, final Group group) {
        DefaultAuthorizationEntry groupAuthorizationEntry = new DefaultAuthorizationEntry(){
            {
                this.setGroup(group);
            }
        };
        authorizationPolicy.registerAuthzEntry(groupAuthorizationEntry);
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)permissionCollection).when((Object)authorizationPolicy)).getPermissions(group);
    }

    private void mockRolePermissions(DefaultAuthorizationPolicy authorizationPolicy, DefaultPermissionCollection permissionCollection, final Role role, final int priority) {
        DefaultAuthorizationEntry roleAuthorizationEntry = new DefaultAuthorizationEntry(){
            {
                this.setRole(role);
                this.setPriority(priority);
            }
        };
        authorizationPolicy.registerAuthzEntry(roleAuthorizationEntry);
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)permissionCollection).when((Object)authorizationPolicy)).getPermissions(role);
    }

    private void mockDefaultPermissions(DefaultAuthorizationPolicy authorizationPolicy, DefaultPermissionCollection permissionCollection) {
        ((DefaultAuthorizationPolicy)Mockito.doReturn((Object)permissionCollection).when((Object)authorizationPolicy)).getPermissions();
    }

    private UserImpl makeUser(String name, Group group, Role ... roles) {
        return new UserImpl(name, Arrays.asList(roles), Collections.singletonList(group));
    }

    private DefaultPermissionCollection makeDeniedPermissionCollection() {
        return new DefaultPermissionCollection(){
            {
                this.add(new Permission[]{DefaultPermissionManagerTest.this.makePermissionDenied()});
            }
        };
    }

    private DefaultPermissionCollection makeGrantedPermissionCollection() {
        return new DefaultPermissionCollection(){
            {
                this.add(new Permission[]{DefaultPermissionManagerTest.this.makePermissionGranted()});
            }
        };
    }

    private DotNamedPermission makePermissionDenied() {
        return new DotNamedPermission(PERMISSION_NAME, Boolean.valueOf(false));
    }

    private DotNamedPermission makePermissionGranted() {
        return new DotNamedPermission(PERMISSION_NAME, Boolean.valueOf(true));
    }
}

