/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorCheckBox;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class BooleanField
extends AbstractField {
    @Inject
    Event<PropertyEditorChangeEvent> propertyEditorChangeEventEvent;

    @Override
    public Widget widget(final PropertyEditorFieldInfo property) {
        final PropertyEditorCheckBox checkBox = (PropertyEditorCheckBox)((Object)GWT.create(PropertyEditorCheckBox.class));
        checkBox.setValue(Boolean.parseBoolean(property.getCurrentStringValue()));
        checkBox.addValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (BooleanField.this.validate(property, checkBox.getValue().toString())) {
                    checkBox.clearOldValidationErrors();
                    property.setCurrentStringValue(checkBox.getValue().toString());
                    BooleanField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, checkBox.getValue().toString()));
                } else {
                    checkBox.setValidationError(BooleanField.this.getValidatorErrorMessage(property, checkBox.getValue().toString()));
                    checkBox.setValue(new Boolean(property.getCurrentStringValue()));
                }
            }
        });
        return checkBox;
    }
}

