/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.fields;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.ext.properties.editor.client.fields.AbstractField;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorPasswordTextBox;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class SecretTextField
extends AbstractField {
    @Inject
    Event<PropertyEditorChangeEvent> propertyEditorChangeEventEvent;

    @Override
    public Widget widget(PropertyEditorFieldInfo property) {
        PropertyEditorPasswordTextBox passwordTextBox = (PropertyEditorPasswordTextBox)((Object)GWT.create(PropertyEditorPasswordTextBox.class));
        passwordTextBox.setText(property.getCurrentStringValue());
        this.addLostFocusHandler(property, passwordTextBox);
        this.addKeyDownHandler(property, passwordTextBox);
        return passwordTextBox;
    }

    private void addLostFocusHandler(final PropertyEditorFieldInfo property, final PropertyEditorPasswordTextBox passwordTextBox) {
        passwordTextBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (SecretTextField.this.validate(property, passwordTextBox.getText())) {
                    passwordTextBox.clearOldValidationErrors();
                    property.setCurrentStringValue(passwordTextBox.getText());
                    SecretTextField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, passwordTextBox.getText()));
                } else {
                    passwordTextBox.setValidationError(SecretTextField.this.getValidatorErrorMessage(property, passwordTextBox.getText()));
                    passwordTextBox.setText(property.getCurrentStringValue());
                }
            }
        });
    }

    private void addKeyDownHandler(final PropertyEditorFieldInfo property, final PropertyEditorPasswordTextBox passwordTextBox) {
        passwordTextBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    if (SecretTextField.this.validate(property, passwordTextBox.getText())) {
                        passwordTextBox.clearOldValidationErrors();
                        property.setCurrentStringValue(passwordTextBox.getText());
                        SecretTextField.this.propertyEditorChangeEventEvent.fire((Object)new PropertyEditorChangeEvent(property, passwordTextBox.getText()));
                    } else {
                        passwordTextBox.setValidationError(SecretTextField.this.getValidatorErrorMessage(property, passwordTextBox.getText()));
                        passwordTextBox.setText(property.getCurrentStringValue());
                    }
                }
            }
        });
    }
}

