/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.InputGroupAddon;
import org.gwtbootstrap3.client.ui.TextBox;
import org.uberfire.ext.properties.editor.client.widgets.AbstractPropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.validators.ColorValidator;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorPickerDialog;
import org.uberfire.ext.widgets.common.client.colorpicker.dialog.DialogClosedEvent;
import org.uberfire.ext.widgets.common.client.colorpicker.dialog.DialogClosedHandler;

public class PropertyEditorColorPicker
extends AbstractPropertyEditorWidget {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    InputGroupAddon icon;
    @UiField
    TextBox colorTextBox;

    public PropertyEditorColorPicker() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.icon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                PropertyEditorColorPicker.this.openColorPickerDialog();
            }
        }, ClickEvent.getType());
    }

    public void setValue(String value) {
        if (ColorValidator.isValid((String)value)) {
            this.colorTextBox.setValue((Object)value);
        }
    }

    public String getValue() {
        return this.colorTextBox.getValue();
    }

    public void addChangeHandler(ValueChangeHandler<String> changeHandler) {
        this.colorTextBox.addValueChangeHandler(changeHandler);
    }

    protected void openColorPickerDialog() {
        final ColorPickerDialog dlg = new ColorPickerDialog();
        dlg.getElement().getStyle().setZIndex(9999);
        String color = this.getValue();
        if (ColorValidator.isValid((String)color)) {
            dlg.setColor(color);
        }
        dlg.addDialogClosedHandler(new DialogClosedHandler(){

            public void dialogClosed(DialogClosedEvent event) {
                if (!event.isCanceled()) {
                    PropertyEditorColorPicker.this.colorTextBox.setValue((Object)dlg.getColor().toUpperCase(), true);
                }
            }
        });
        dlg.showRelativeTo((UIObject)this.icon);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, PropertyEditorColorPicker> {
    }
}

