/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.properties.editor.client.PropertyEditorHelper;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.client.widgets.PropertyEditorItemLabel;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Heading.class})
public class PropertyEditorHelperTest {
    @Test(expected=PropertyEditorHelper.NullEventException.class)
    public void validateNullEventTest() {
        PropertyEditorHelper.validade(null);
    }

    @Test(expected=PropertyEditorHelper.NoPropertiesException.class)
    public void validateEventWithNoPropertiesTest() {
        PropertyEditorEvent event = new PropertyEditorEvent("id", new ArrayList());
        PropertyEditorHelper.validade((PropertyEditorEvent)event);
    }

    @Test
    public void validateEventTest() {
        ArrayList<PropertyEditorCategory> properties = new ArrayList<PropertyEditorCategory>();
        properties.add(new PropertyEditorCategory("Category"));
        PropertyEditorEvent event = new PropertyEditorEvent("id", properties);
        Assert.assertTrue((boolean)PropertyEditorHelper.validade((PropertyEditorEvent)event));
    }

    @Test
    public void isAMatchOfEmptyFilterTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo();
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"", (PropertyEditorFieldInfo)field));
    }

    @Test
    public void isAMatchOfFilterTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo("label", PropertyEditorType.TEXT);
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"l", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"label", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LABEL", (PropertyEditorFieldInfo)field));
        Assert.assertTrue((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"abel", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LABELL", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"LASBELL", (PropertyEditorFieldInfo)field));
        Assert.assertFalse((boolean)PropertyEditorHelper.isAMatchOfFilter((String)"p", (PropertyEditorFieldInfo)field));
    }

    @Test
    public void createLabelTest() {
        PropertyEditorFieldInfo field = new PropertyEditorFieldInfo("label", PropertyEditorType.TEXT);
        PropertyEditorItemLabel label = PropertyEditorHelper.createLabel((PropertyEditorFieldInfo)field);
        ((PropertyEditorItemLabel)Mockito.verify((Object)label)).setText("label");
    }

    @Test
    public void createCategoryWithNoFields() {
        PropertyEditorWidget propertyEditorWidget = (PropertyEditorWidget)GWT.create(PropertyEditorWidget.class);
        PanelGroup propertyMenu = (PanelGroup)GWT.create(PanelGroup.class);
        PropertyEditorCategory category = new PropertyEditorCategory("1");
        PropertyEditorHelper.createCategory((PropertyEditorWidget)propertyEditorWidget, (PanelGroup)propertyMenu, (PropertyEditorCategory)category, (String)"");
        ((PanelGroup)Mockito.verify((Object)propertyMenu, (VerificationMode)Mockito.never())).add((Widget)Mockito.any(Widget.class));
    }
}

