/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.bayesian.network.client.screen;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.wires.bayesian.network.client.events.BayesianTemplateSelectedEvent;
import org.uberfire.ext.wires.bayesian.network.client.events.RenderBayesianNetworkEvent;
import org.uberfire.ext.wires.bayesian.network.client.factory.BayesianFactory;
import org.uberfire.ext.wires.bayesian.network.client.shapes.EditableBayesianNode;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.api.events.ShapeAddedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.canvas.WiresCanvas;

@Dependent
@WorkbenchScreen(identifier="BayesianScreen")
public class BayesianScreen
extends WiresCanvas {
    @Inject
    private BayesianFactory factory;
    @Inject
    private Event<ClearEvent> clearEvent;
    @Inject
    private Event<ShapeSelectedEvent> shapeSelectedEvent;
    @Inject
    private Event<ShapeAddedEvent> shapeAddedEvent;

    public void onBayesianEvent(@Observes BayesianTemplateSelectedEvent event) {
        this.factory.init(event.getTemplate());
    }

    public void onReadyEvent(@Observes RenderBayesianNetworkEvent event) {
        this.clearEvent.fire((Object)new ClearEvent());
        for (EditableBayesianNode node : event.getBayesianNodes()) {
            this.addShape(node);
        }
    }

    public void onClearEvent(@Observes ClearEvent clearEvent) {
        this.clear();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Bayesian Network";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this;
    }

    public void addShape(WiresBaseShape shape) {
        super.addShape(shape);
        this.shapeAddedEvent.fire((Object)new ShapeAddedEvent(shape));
    }

    public void selectShape(WiresBaseShape shape) {
        this.shapeSelectedEvent.fire((Object)new ShapeSelectedEvent(shape));
    }

    public void onShapeSelected(@Observes ShapeSelectedEvent event) {
        super.selectShape(event.getShape());
    }
}

